/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidableAnotado;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.ats.modelo.util.InfoPantallas;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DetalleAir
extends ObjetoModeloSucesorValidableAnotado<ObjetoModelo>
implements InformacionEditable<DetalleAir>,
Exportable,
Importable {
    private static final long serialVersionUID = -7309012179733549288L;
    public static final String C_CONCEPTO_RETENCION = "conceptoRetencion";
    public static final String C_BASE_IMPONIBLE_RENTA = "baseImponibleRenta";
    public static final String C_PORCENTAJE_RETENCION = "porcentajeRetencion";
    public static final String C_VALOR_RETENIDO = "valorRetenido";
    private static final String M_BASE_IR = "Base Imponible Renta";
    private static final String M_MONTO_RET = "Monto de Retenci\u00f3n";
    private static final String VALOR = "El valor ";
    @NotNull(message="Debe seleccionar el tipo de Rendimiento Financiero")
    private String conceptoRetencion;
    private String descripcionConcepto;
    @NotNull(message="Debe ingresar el valor de Base Imponible Renta")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Base Imponible Renta debe ser 12 enteros y 2 decimales. ")
    private String baseImponibleRenta = "0.00";
    @NotNull(message="Debe ingresar el valor de Monto de Retenci\u00f3n")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Monto de Retenci\u00f3n debe ser 12 enteros y 2 decimales. ")
    private String valorRetenido = "0.00";
    @NotNull(message="El valor Porcentaje Retenci\u00f3n es necesario")
    @Pattern(regexp="^[0-9]{1,3}+(\\.[0-9]{2})?$", message="El valor Porcentaje de Retenci\u00f3n debe 2 enteros y 2 decimales o 100")
    private String porcentajeRetencion = "0.00";
    protected BigDecimal valorRetenidoCalculado = BigDecimal.ZERO;

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (this.validarDetalleAirRepetido(resultado).esEstadoFallido()) {
            return resultado;
        }
        if (this.validarPorcentajeCien(resultado).esEstadoFallido()) {
            return resultado;
        }
        if (!this.validarValorRetenido(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        if (!this.validacionExtra(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        return resultado.esEstadoExitoso() ? resultado.pasarValidacion() : resultado;
    }

    public DetalleAir crearCopiaEdicion() {
        DetalleAir copia = new DetalleAir();
        copia.setConceptoRetencion(this.conceptoRetencion);
        copia.setDescripcionConcepto(this.descripcionConcepto);
        copia.setBaseImponibleRenta(this.baseImponibleRenta);
        copia.setValorRetenido(this.valorRetenido);
        copia.setPorcentajeRetencion(this.porcentajeRetencion);
        copia.setPropietario(this.propietario);
        return copia;
    }

    public void actualizarInformacion(DetalleAir copiaEdicion) {
        this.setConceptoRetencion(copiaEdicion.getConceptoRetencion());
        this.setDescripcionConcepto(copiaEdicion.getDescripcionConcepto());
        this.setBaseImponibleRenta(copiaEdicion.getBaseImponibleRenta());
        this.setValorRetenido(copiaEdicion.getValorRetenido());
        this.setPorcentajeRetencion(copiaEdicion.getPorcentajeRetencion());
    }

    private ResultadoValidacion validarDetalleAirRepetido(ResultadoValidacion resultado) {
        String codigoActual = (String)this.getContextoValidacion().obtener(InfoPantallas.AIR_ACTUAL.toString());
        List codigosExistentes = (List)this.getContextoValidacion().obtener(InfoPantallas.AIR_EXISTENTES.toString());
        if (!this.getConceptoRetencion().equals(codigoActual) && codigosExistentes.contains(this.getConceptoRetencion())) {
            resultado.fallarValidacion("El concepto de rentenci\u00f3n ya se encuentra registrado");
        }
        return resultado;
    }

    protected ResultadoValidacion validarValorRetenido(ResultadoValidacion resultado) {
        if (Util.getBigDecimal(this.getValorRetenido()).compareTo(Util.getBigDecimal(this.getBaseImponibleRenta())) == 1) {
            return resultado.fallarValidacion("El valor retenido no puede ser mayor al valor Base Imponible Renta");
        }
        if (this.valorRetenidoCalculado.compareTo(Util.getBigDecimal(this.getValorRetenido())) != 0) {
            if (Util.isMargenErrorMasMenos(this.valorRetenidoCalculado, this.getValorRetenido(), Constantes.MARGEN_ERROR)) {
                return resultado.pasarValidacionAdvertencia("El Valor Retenido " + this.getValorRetenido() + " no corresponde al valor calculado " + this.valorRetenidoCalculado);
            }
            return resultado.fallarValidacion("El Valor Retenido " + this.getValorRetenido() + " no corresponde al valor calculado " + this.valorRetenidoCalculado);
        }
        return resultado;
    }

    private ResultadoValidacion validarPorcentajeCien(ResultadoValidacion resultado) {
        if (Util.getBigDecimal(this.getPorcentajeRetencion()).compareTo(Constantes.CIEN) == 1) {
            return resultado.fallarValidacion("El valor Porcentaje de Retenci\u00f3n no puede ser mayor 100");
        }
        return resultado;
    }

    protected void calcularValorRetenido() {
        this.valorRetenidoCalculado = Util.getPorcentaje(Util.getBigDecimal(this.getBaseImponibleRenta()), Util.getBigDecimal(this.getPorcentajeRetencion()));
    }

    protected ResultadoValidacion validacionExtra(ResultadoValidacion resultado) {
        return resultado;
    }

    protected void validacionAnotadaExitosa() {
        this.calcularValorRetenido();
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("codRetAir");
        Element eValor = (Element)valorList.item(0);
        this.conceptoRetencion = eValor.getTextContent().trim();
        this.descripcionConcepto = String.valueOf(this.getConceptoRetencion()) + "-" + UtilCatalogosATS.crearInstancia().obtenerDescripcionRetencion(this.getConceptoRetencion(), ((Iva)this.getRaizModelo()).getDatosDeclaracion().getMes(), ((Iva)this.getRaizModelo()).getDatosDeclaracion().getAnio(), ((Iva)this.getRaizModelo()).getDatosDeclaracion().getMicro());
        valorList = elemento.getElementsByTagName("baseImpAir");
        eValor = (Element)valorList.item(0);
        this.baseImponibleRenta = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("valRetAir");
        eValor = (Element)valorList.item(0);
        this.valorRetenido = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("porcentajeAir");
        eValor = (Element)valorList.item(0);
        this.porcentajeRetencion = eValor.getTextContent().trim();
        return this;
    }

    public String getConceptoRetencion() {
        return this.conceptoRetencion;
    }

    public String getDescripcionConcepto() {
        return this.descripcionConcepto;
    }

    public String getBaseImponibleRenta() {
        return this.baseImponibleRenta;
    }

    public String getValorRetenido() {
        return this.valorRetenido;
    }

    public String getPorcentajeRetencion() {
        return this.porcentajeRetencion;
    }

    public void setConceptoRetencion(String conceptoRetencion) {
        String oldValue = this.conceptoRetencion;
        this.conceptoRetencion = conceptoRetencion;
        this.firePropertyChange(C_CONCEPTO_RETENCION, oldValue, this.conceptoRetencion);
    }

    public void setDescripcionConcepto(String descripcionConcepto) {
        this.descripcionConcepto = descripcionConcepto;
    }

    public void setBaseImponibleRenta(String baseImponibleRenta) {
        String oldValue = this.baseImponibleRenta;
        this.baseImponibleRenta = baseImponibleRenta;
        this.firePropertyChange(C_BASE_IMPONIBLE_RENTA, oldValue, this.baseImponibleRenta);
    }

    public void setValorRetenido(String valorRetenido) {
        String oldValue = this.valorRetenido;
        this.valorRetenido = valorRetenido;
        this.firePropertyChange(C_VALOR_RETENIDO, oldValue, this.valorRetenido);
    }

    public void setPorcentajeRetencion(String porcentajeRetencion) {
        String oldValue = this.porcentajeRetencion;
        this.porcentajeRetencion = porcentajeRetencion;
        this.firePropertyChange(C_PORCENTAJE_RETENCION, oldValue, this.porcentajeRetencion);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.conceptoRetencion == null ? 0 : this.conceptoRetencion.hashCode());
        return result;
    }

    public Element exportar(Document documento, Element elemento) {
        Element detalleAir = documento.createElement("detalleAir");
        Element em = documento.createElement("codRetAir");
        em.setTextContent(this.getConceptoRetencion());
        detalleAir.appendChild(em);
        em = documento.createElement("baseImpAir");
        em.setTextContent(this.getBaseImponibleRenta());
        detalleAir.appendChild(em);
        em = documento.createElement("porcentajeAir");
        em.setTextContent(this.getPorcentajeRetencion());
        detalleAir.appendChild(em);
        em = documento.createElement("valRetAir");
        em.setTextContent(this.getValorRetenido());
        detalleAir.appendChild(em);
        return detalleAir;
    }
}

